﻿<%@ Control Language="C#" Inherits="System.Web.Mvc.ViewUserControl<UserProfile>" %>
    <% if (!Request.IsAuthenticated) %>
    <% { %>
        <p>
            <a id="loginLink" href="<%=Html.AttributeEncode(WindowsLiveId.WindowsLiveHelper.RetrieveMobileLoginUrl(Request.Url.PathAndQuery))%>" title="Sign In using Windows LiveID"><img alt="Sign In using Windows LiveID" src="<%=Url.Content("~/Content/Images/signin.gif")%>" width="66" height="19"/></a>
        </p>
        <script type="text/javascript">
            //<![CDATA[
            function replaceQueryString(url, param, value) {
                var re = new RegExp("([?|&])" + param + "=.*?(&|$)", "i");
                if (url.match(re))
                    return url.replace(re, '$1' + param + "=" + value + '$2');
                else
                    return url + '&' + param + "=" + value;
            }

            function addAnchorDataToLiveId(anchor) {
                anchor.href = replaceQueryString(anchor.href, "appctx", escape(location.href.substring(location.href.indexOf('/', 10))));
            }
            
            var anchor = document.getElementById("loginLink");
            anchor.href = "<%=WindowsLiveId.WindowsLiveHelper.RetrieveLoginUrl(Request.Url.PathAndQuery)%>";
            anchor.onclick = function() { addAnchorDataToLiveId(this); }
            //]]>
        </script>
    <% } else { %>
        <p>
            <span>Hello <%:Model.FullName%>!</span>
            <span>
            <a id="logoutLink" href="<%=Url.Action("LiveId", "Account") %>?action=logout" title="Sign Out"><img alt="Sign Out" src="<%=Url.Content("~/Content/Images/signout.gif")%>" width="66" height="19"/></a></span>
        </p>
        <script type="text/javascript">
            //<![CDATA[
            document.getElementById("logoutLink").href = "<%=WindowsLiveId.WindowsLiveHelper.RetrieveLogoutUrl()%>";
            //]]>
        </script>
    <% } %>